

USE SUCOS_VENDAS
CREATE TABLE TST_BACKUP (POS INT)
INSERT INTO TST_BACKUP (POS) VALUES (1)
SELECT * FROM TST_BACKUP

-- 1:00 AM -- BACKUP FULL INICIAL

INSERT INTO TST_BACKUP (POS) VALUES (1)
BACKUP DATABASE SUCOS_VENDAS TO DISK = 'C:\Temp\SQL\SUCOS_VENDAS_COMPLETO.BAK'
WITH INIT

-- 4:00 AM - BACKUP LOG
INSERT INTO TST_BACKUP (POS) VALUES (2)
BACKUP LOG SUCOS_VENDAS TO DISK = 'C:\Temp\SQL\SUCOS_VENDAS_COMPLETO.BAK'
WITH NOINIT

-- 6:00 AM - BACKUP LOG
INSERT INTO TST_BACKUP (POS) VALUES (3)
BACKUP LOG SUCOS_VENDAS TO DISK = 'C:\Temp\SQL\SUCOS_VENDAS_COMPLETO.BAK'
WITH NOINIT

-- 8:00 AM - BACKUP LOG
INSERT INTO TST_BACKUP (POS) VALUES (4)
BACKUP LOG SUCOS_VENDAS TO DISK = 'C:\Temp\SQL\SUCOS_VENDAS_COMPLETO.BAK'
WITH NOINIT

-- 9:00 AM - BACKUP DIFERENCIAL
INSERT INTO TST_BACKUP (POS) VALUES (5)
BACKUP DATABASE SUCOS_VENDAS TO DISK = 'C:\Temp\SQL\SUCOS_VENDAS_COMPLETO.BAK'
WITH DIFFERENTIAL

-- 10:00 AM - BACKUP LOG
INSERT INTO TST_BACKUP (POS) VALUES (6)
BACKUP LOG SUCOS_VENDAS TO DISK = 'C:\Temp\SQL\SUCOS_VENDAS_COMPLETO.BAK'
WITH NOINIT

-- 12:00 PM - BACKUP LOG
INSERT INTO TST_BACKUP (POS) VALUES (7)
BACKUP LOG SUCOS_VENDAS TO DISK = 'C:\Temp\SQL\SUCOS_VENDAS_COMPLETO.BAK'
WITH NOINIT

-- 14:00 PM - BACKUP LOG
INSERT INTO TST_BACKUP (POS) VALUES (8)
BACKUP LOG SUCOS_VENDAS TO DISK = 'C:\Temp\SQL\SUCOS_VENDAS_COMPLETO.BAK'
WITH NOINIT

-- 14:00 PM - BACKUP DIFERENCIAL
INSERT INTO TST_BACKUP (POS) VALUES (9)
BACKUP DATABASE SUCOS_VENDAS TO DISK = 'C:\Temp\SQL\SUCOS_VENDAS_COMPLETO.BAK'
WITH DIFFERENTIAL

-- 15:00 PM - BACKUP LOG
INSERT INTO TST_BACKUP (POS) VALUES (10)
BACKUP LOG SUCOS_VENDAS TO DISK = 'C:\Temp\SQL\SUCOS_VENDAS_COMPLETO.BAK'
WITH NOINIT

-- 17:00 PM - BACKUP LOG
INSERT INTO TST_BACKUP (POS) VALUES (11)
BACKUP LOG SUCOS_VENDAS TO DISK = 'C:\Temp\SQL\SUCOS_VENDAS_COMPLETO.BAK'
WITH NOINIT


-- 17:30 - RECUPEROU BACKUP


-- 19:00 PM - BACKUP LOG
INSERT INTO TST_BACKUP (POS) VALUES (12)
BACKUP LOG SUCOS_VENDAS TO DISK = 'C:\Temp\SQL\SUCOS_VENDAS_COMPLETO.BAK'
WITH NOINIT

-- 21:00 PM - BACKUP LOG
INSERT INTO TST_BACKUP (POS) VALUES (13)
BACKUP LOG SUCOS_VENDAS TO DISK = 'C:\Temp\SQL\SUCOS_VENDAS_COMPLETO.BAK'
WITH NOINIT

SELECT * FROM TST_BACKUP

RESTORE HEADERONLY FROM DISK = 'C:\Temp\SQL\SUCOS_VENDAS_COMPLETO.BAK'


-- quero recuperar os dados de 17:300 PM

-- 1:00 AM -- BACKUP FULL INICIAL (1)
-- 14:00 PM - BACKUP DIFERENCIAL (9)
-- 15:00 PM - BACKUP LOG (10)
-- 17:00 PM - BACKUP LOG (11)

USE MASTER
ALTER DATABASE SUCOS_VENDAS SET SINGLE_USER WITH ROLLBACK IMMEDIATE
DROP DATABASE SUCOS_VENDAS

-- 1:00 AM -- BACKUP FULL INICIAL (1)
RESTORE DATABASE SUCOS_VENDAS FROM DISK = 'C:\Temp\SQL\SUCOS_VENDAS_COMPLETO.BAK'
WITH FILE = 1, NORECOVERY
-- 14:00 PM - BACKUP DIFERENCIAL (9)
RESTORE DATABASE SUCOS_VENDAS FROM DISK = 'C:\Temp\SQL\SUCOS_VENDAS_COMPLETO.BAK'
WITH FILE = 9, NORECOVERY
-- 15:00 PM - BACKUP LOG (10)
RESTORE LOG SUCOS_VENDAS FROM DISK = 'C:\Temp\SQL\SUCOS_VENDAS_COMPLETO.BAK'
WITH FILE = 10, NORECOVERY
-- 17:00 PM - BACKUP LOG (11)
RESTORE LOG SUCOS_VENDAS FROM DISK = 'C:\Temp\SQL\SUCOS_VENDAS_COMPLETO.BAK'
WITH FILE = 11, RECOVERY

USE SUCOS_VENDAS
SELECT * FROM TST_BACKUP





